function [Gapz,infeas,time_vec,X,D,y] = AGP(gradX,gradD,grady,X0,D0,y0,param)
disp('***AGP Starts***');
% initialization and parameter selection
X = X0;
D = D0;
y = y0;
maxiter = param.maxiter;
r = param.r;
B = param.B;
[m,q] = size(D);
Gapz_min = inf;
Gapz = [];
sk1 = sparse(m,q);
aux = eye(m,q);
time_vec = [];
infeas = [];
elaps = 0;
% main steps
for i = 1:maxiter
    tic;
    GX = gradX(D,X,y); % gradient w.r.t C
    GD = gradD(D,X,y); % gradient w.r.t D
    Gy = grady(D,X,y); % gradient w.r.t y
    
    tau = 1*sqrt(i);
    D = D - (1/tau) * GD;
    ind = sum_square(D)>1;
    D_new = D;
    D_new(:,ind) = D(:,ind)./sqrt(sum_square(D(:,ind)));

    X = X - (1/tau) * GX;
    [U,S,V] = svd(full(X));
    d = diag(S);
    [dim1,dim2] = size(S);
    if (sum(d) > r) 
        newd = simplex_proj(d,r);
	    X_new = U * [diag(newd),zeros(dim1,dim2-dim1)] * V';
    else
        X_new = X;
    end
    
    gamma = 10/2 ; 
    c = 0.1/ (i^0.25); 
    y_new = max(0,min(B,y + (1/gamma) * Gy - (1/gamma) * c * y));

    time_iter = toc;

    % calculating the gap function
    pk = max(0,Gy)*B/norm(Gy);
    ind = sum_square(GD)==0;
    sk1(:,ind) = aux(:,ind);
    sk1(:,~ind) = -GD(:,~ind)./sqrt(sum_square(GD(:,~ind)));
    [u,~,v] = svds(GX,1);
    sk2 = -r*sparse(u)*sparse(v');
    if i<maxiter/2
        Gapz = [Gapz;trace(GX'*(X-sk2))+trace(GD'*(D-sk1))+(Gy)'*(pk-y)];
        infeas = [infeas;pos(grady(D,X,y))];
    else
        Gapz_min = min(abs(Gapz_min),trace(GX'*(X-sk2))+trace(GD'*(D-sk1))+(Gy)'*(pk-y));
        Gapz = [Gapz;Gapz_min];
        infeas = [infeas;pos(grady(D,X,y))];
    end
    D = D_new;
    X = X_new;
    y = y_new;
    elaps = elaps+time_iter;
    time_vec = [time_vec;elaps];
end
disp('***AGP is Done!***');
end